package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.ExamHIVData;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.ng.entities.ExamHIV_Ng;

/**
 * Created by rmemoria on 14/9/17.
 */
public class ExamHivConsumer extends SyncDataConsumerImpl<ExamHIVData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ExamHIVData data) {
        ExamHIV_Ng exam = recoverEntity(ExamHIV_Ng.class, data.getServerId());

        if (exam.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            exam.setTbcase(tbcase);
        }

        exam.setDate(data.getDate());
        exam.setComments(data.getComments());
        exam.setResult(data.getResult());
        exam.setCd4Count(data.getCd4Count());
        exam.setCd4StDate(data.getCd4StDate());
        exam.setLaboratory(data.getLaboratory());
        exam.setStartedARTdate(data.getStartedARTdate());
        exam.setStartedCPTdate(data.getStartedCPTdate());

        getEntityManager().persist(exam);

        return data.getServerId() == null ? exam.getId() : null;
    }
}
